<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes"/>
<xsl:param name="style">normal</xsl:param>
<xsl:param name="model"></xsl:param>
<xsl:param name="mnlno"></xsl:param>
<xsl:param name="AC"></xsl:param>
<xsl:param name="US"></xsl:param>
<xsl:param name="PS"></xsl:param>
<xsl:param name="SP"></xsl:param>
<xsl:param name="PO"></xsl:param>
<xsl:param name="SM"></xsl:param>
<xsl:param name="ME"></xsl:param>
<xsl:param name="UR"></xsl:param>
<xsl:param name="browser">IE</xsl:param>

<xsl:template match="/">
<xsl:if test="$browser = 'IE'">
	<xsl:choose>
		<xsl:when test="$style = 'normal'">
			<xsl:call-template name="normal"/>
		</xsl:when>
		<xsl:when test="$style = 'jpost'">
			<xsl:call-template name="jpost"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper1'">
			<xsl:call-template name="jasper1"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper2'">
			<xsl:call-template name="jasper2"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper3'">
			<xsl:call-template name="jasper3"/>
		</xsl:when>
		<xsl:when test="$style = 'csv'">
			<xsl:call-template name="csv"/>
		</xsl:when>
	</xsl:choose>
</xsl:if>
<xsl:if test="$browser = 'NS'">
<html>
	<xsl:choose>
		<xsl:when test="$style = 'normal'">
			<xsl:call-template name="normal"/>
		</xsl:when>
		<xsl:when test="$style = 'jpost'">
			<xsl:call-template name="jpost"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper1'">
			<xsl:call-template name="jasper1"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper2'">
			<xsl:call-template name="jasper2"/>
		</xsl:when>
		<xsl:when test="$style = 'jasper3'">
			<xsl:call-template name="jasper3"/>
		</xsl:when>
		<xsl:when test="$style = 'csv'">
			<xsl:call-template name="csv"/>
		</xsl:when>
	</xsl:choose>
</html>
</xsl:if>
</xsl:template>

<xsl:template name="normal">
Model No.%09:<xsl:value-of select='$model'/>%0D%0A
Namual No.%09:<xsl:value-of select='$mnlno'/>%0D%0A
-----------------------------------------------------%0D%0A
<xsl:for-each select="//ROW">
<xsl:value-of select='BLKNO'/>-<xsl:value-of select='SYMBOL'/>%09<xsl:value-of select='PART'/>%09<xsl:value-of select='NAME'/>%09<xsl:value-of select='ORDERQTY'/>%0D%0A
</xsl:for-each>
</xsl:template>

<xsl:template name="jpost">
#AC=<xsl:value-of select='$AC'/>%0D%0A
#US=<xsl:value-of select='$US'/>%0D%0A
#PS=<xsl:value-of select='$PS'/>%0D%0A
#SP=<xsl:value-of select='$SP'/>%0D%0A
#PO=<xsl:value-of select='$PO'/>%0D%0A
#SM=<xsl:value-of select='$SM'/>%0D%0A
#ME=<xsl:value-of select='$ME'/>%0D%0A
#UR=<xsl:value-of select='$UR'/>%0D%0A
</xsl:template>

<xsl:template name="jasper1">
<xsl:value-of select='$US'/>%0D%0A
<xsl:value-of select='$PS'/>%0D%0A
<xsl:value-of select='$PO'/>%0D%0A
<xsl:for-each select="//ROW">
<xsl:value-of select='PART'/>%20<xsl:value-of select='ORDERQTY'/>%0D%0A
</xsl:for-each>
end
</xsl:template>

<xsl:template name="jasper2">
<xsl:value-of select='$US'/>%0D%0A
<xsl:value-of select='$PS'/>%0D%0A
<xsl:for-each select="//ROW">
<xsl:value-of select='PART'/>%0D%0A
</xsl:for-each>
end
</xsl:template>

<xsl:template name="jasper3">
<xsl:value-of select='$US'/>%0D%0A
<xsl:value-of select='$PS'/>%0D%0A
</xsl:template>

<xsl:template name="csv">
<xsl:for-each select="//ROW"><xsl:value-of select='PART'/><xsl:text disable-output-escaping="yes">&#09;</xsl:text><xsl:value-of select='ORDERQTY'/><xsl:text disable-output-escaping="yes">&#09;</xsl:text><xsl:value-of select='$model'/><xsl:text disable-output-escaping="yes">&#09;</xsl:text><xsl:value-of select='NAME'/><xsl:text disable-output-escaping="yes">&#10;</xsl:text></xsl:for-each>
</xsl:template>

</xsl:stylesheet>
